/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.repurposedstructures.utils;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.mojang.datafixers.util.Pair;
import com.telepathicgrunt.repurposedstructures.RepurposedStructures;
import com.telepathicgrunt.repurposedstructures.misc.BiomeDimensionAllowDisallow;
import com.telepathicgrunt.repurposedstructures.mixin.resources.NamespaceResourceManagerAccessor;
import com.telepathicgrunt.repurposedstructures.mixin.resources.ReloadableResourceManagerImplAccessor;
import com.telepathicgrunt.repurposedstructures.utils.CodecCache;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.FrontAndTop;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.packs.PackResources;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.resources.FallbackResourceManager;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.NoiseColumn;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.JigsawBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.feature.ConfiguredStructureFeature;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.phys.shapes.VoxelShape;

public final class GeneralUtils {
    private static final Map<BlockState, Boolean> IS_FULLCUBE_MAP = new ConcurrentHashMap<BlockState, Boolean>();
    private static ConcurrentHashMap<FeatureConfiguration, ResourceLocation> CACHED_CONFIG_TO_CSF_RL = new ConcurrentHashMap();
    private static final CodecCache<PlacedFeature> placedFeatureCodecCache = CodecCache.of(PlacedFeature.f_191772_);

    private GeneralUtils() {
    }

    public static <T> T getRandomEntry(List<Pair<T, Integer>> rlList, Random random) {
        int index;
        double totalWeight = 0.0;
        for (Pair<T, Integer> pair : rlList) {
            totalWeight += (double)((Integer)pair.getSecond()).intValue();
        }
        double randomWeightPicked = (double)random.nextFloat() * totalWeight;
        for (index = 0; index < rlList.size() - 1 && !((randomWeightPicked -= (double)((Integer)rlList.get(index).getSecond()).intValue()) <= 0.0); ++index) {
        }
        return (T)rlList.get(index).getFirst();
    }

    public static boolean isFullCube(BlockGetter world, BlockPos pos, BlockState state) {
        if (state == null) {
            return false;
        }
        return IS_FULLCUBE_MAP.computeIfAbsent(state, stateIn -> Block.m_49916_((VoxelShape)stateIn.m_60768_(world, pos)));
    }

    public static BlockState orientateChest(ServerLevelAccessor blockView, BlockPos blockPos, BlockState blockState) {
        BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos();
        Direction wallDirection = (Direction)blockState.m_61143_((Property)HorizontalDirectionalBlock.f_54117_);
        for (Direction facing : Direction.Plane.HORIZONTAL) {
            mutable.m_122190_((Vec3i)blockPos).m_122173_(facing);
            if (!GeneralUtils.isFullCube((BlockGetter)blockView, (BlockPos)mutable, blockView.m_8055_((BlockPos)mutable))) continue;
            wallDirection = facing;
            mutable.m_122175_(facing.m_122424_(), 2);
            if (blockView.m_8055_((BlockPos)mutable).m_60767_().m_76333_()) continue;
            break;
        }
        return (BlockState)blockState.m_61124_((Property)HorizontalDirectionalBlock.f_54117_, (Comparable)wallDirection.m_122424_());
    }

    public static boolean isBlacklistedForWorld(ServerLevelAccessor currentWorld, ResourceLocation worldgenObjectID) {
        ResourceLocation worldID = currentWorld.m_6018_().m_46472_().m_135782_();
        boolean allowInDim = ((List)BiomeDimensionAllowDisallow.DIMENSION_DISALLOW.getOrDefault(worldgenObjectID, new ArrayList())).stream().noneMatch(pattern -> pattern.matcher(worldID.toString()).find());
        if (!allowInDim && ((List)BiomeDimensionAllowDisallow.DIMENSION_ALLOW.getOrDefault(worldgenObjectID, new ArrayList())).stream().anyMatch(pattern -> pattern.matcher(worldID.toString()).find())) {
            allowInDim = true;
        }
        return !allowInDim;
    }

    public static ItemStack enchantRandomly(Random random, ItemStack itemToEnchant, float chance) {
        List list;
        if (random.nextFloat() < chance && !(list = Registry.f_122825_.m_123024_().filter(Enchantment::m_6592_).filter(enchantmentToCheck -> enchantmentToCheck.m_6081_(itemToEnchant)).collect(Collectors.toList())).isEmpty()) {
            Enchantment enchantment = (Enchantment)list.get(random.nextInt(list.size()));
            int enchantmentLevel = random.nextInt(Mth.m_14072_((Random)random, (int)enchantment.m_44702_(), (int)enchantment.m_6586_()) + 1);
            itemToEnchant.m_41663_(enchantment, enchantmentLevel);
        }
        return itemToEnchant;
    }

    public static int getMaxTerrainLimit(ChunkGenerator chunkGenerator) {
        return chunkGenerator.m_142062_() + chunkGenerator.m_6331_();
    }

    public static BlockPos getHighestLand(ChunkGenerator chunkGenerator, BoundingBox boundingBox, LevelHeightAccessor heightLimitView, boolean canBeOnLiquid) {
        BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos().m_122178_(boundingBox.m_162394_().m_123341_(), GeneralUtils.getMaxTerrainLimit(chunkGenerator) - 20, boundingBox.m_162394_().m_123343_());
        NoiseColumn blockView = chunkGenerator.m_141914_(mutable.m_123341_(), mutable.m_123343_(), heightLimitView);
        while (mutable.m_123342_() > chunkGenerator.m_6337_()) {
            BlockState currentBlockstate = blockView.m_183556_(mutable.m_123342_());
            if (!currentBlockstate.m_60815_()) {
                mutable.m_122173_(Direction.DOWN);
                continue;
            }
            if (blockView.m_183556_(mutable.m_123342_() + 3).m_60767_() == Material.f_76296_ && (canBeOnLiquid ? !currentBlockstate.m_60795_() : currentBlockstate.m_60815_())) {
                return mutable;
            }
            mutable.m_122173_(Direction.DOWN);
        }
        return mutable;
    }

    public static BlockPos getLowestLand(ChunkGenerator chunkGenerator, BoundingBox boundingBox, LevelHeightAccessor heightLimitView, boolean canBeOnLiquid) {
        BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos().m_122178_(boundingBox.m_162394_().m_123341_(), chunkGenerator.m_6337_() + 1, boundingBox.m_162394_().m_123343_());
        NoiseColumn blockView = chunkGenerator.m_141914_(mutable.m_123341_(), mutable.m_123343_(), heightLimitView);
        BlockState currentBlockstate = blockView.m_183556_(mutable.m_123342_());
        while (mutable.m_123342_() <= GeneralUtils.getMaxTerrainLimit(chunkGenerator) - 20) {
            if ((canBeOnLiquid ? !currentBlockstate.m_60795_() : currentBlockstate.m_60815_()) && blockView.m_183556_(mutable.m_123342_() + 1).m_60767_() == Material.f_76296_ && blockView.m_183556_(mutable.m_123342_() + 5).m_60767_() == Material.f_76296_) {
                mutable.m_122173_(Direction.UP);
                return mutable;
            }
            mutable.m_122173_(Direction.UP);
            currentBlockstate = blockView.m_183556_(mutable.m_123342_());
        }
        return mutable.m_122178_(mutable.m_123341_(), chunkGenerator.m_6337_(), mutable.m_123343_());
    }

    public static int getFirstLandYFromPos(LevelReader worldView, BlockPos pos) {
        BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos();
        mutable.m_122190_((Vec3i)pos);
        ChunkAccess currentChunk = worldView.m_46865_((BlockPos)mutable);
        BlockState currentState = currentChunk.m_8055_((BlockPos)mutable);
        while (mutable.m_123342_() >= worldView.m_141937_() && GeneralUtils.isReplaceableByStructures(currentState)) {
            mutable.m_122173_(Direction.DOWN);
            currentState = currentChunk.m_8055_((BlockPos)mutable);
        }
        return mutable.m_123342_();
    }

    private static boolean isReplaceableByStructures(BlockState blockState) {
        return blockState.m_60795_() || blockState.m_60767_().m_76332_() || blockState.m_60767_().m_76336_();
    }

    public static ResourceLocation getCsfNameForConfig(FeatureConfiguration config, RegistryAccess registries) {
        return CACHED_CONFIG_TO_CSF_RL.computeIfAbsent(config, c -> ((ResourceKey)registries.m_175515_(Registry.f_122882_).m_6579_().stream().filter(entry -> ((ConfiguredStructureFeature)entry.getValue()).f_65404_ == config).findFirst().get().getKey()).m_135782_());
    }

    public static void clearCachedConfigToCsfRlMap() {
        CACHED_CONFIG_TO_CSF_RL.clear();
    }

    public static void centerAllPieces(BlockPos targetPos, List<? extends StructurePiece> pieces) {
        if (pieces.isEmpty()) {
            return;
        }
        BlockPos structureCenter = pieces.get(0).m_73547_().m_162394_();
        int xOffset = targetPos.m_123341_() - structureCenter.m_123341_();
        int zOffset = targetPos.m_123343_() - structureCenter.m_123343_();
        for (StructurePiece structurePiece : pieces) {
            structurePiece.m_6324_(xOffset, 0, zOffset);
        }
    }

    public static boolean canJigsawsAttach(StructureTemplate.StructureBlockInfo jigsaw1, StructureTemplate.StructureBlockInfo jigsaw2) {
        FrontAndTop prop1 = (FrontAndTop)jigsaw1.f_74676_.m_61143_((Property)JigsawBlock.f_54222_);
        FrontAndTop prop2 = (FrontAndTop)jigsaw2.f_74676_.m_61143_((Property)JigsawBlock.f_54222_);
        String joint = jigsaw1.f_74677_.m_128461_("joint");
        if (joint.isEmpty()) {
            joint = prop1.m_122625_().m_122434_().m_122479_() ? "aligned" : "rollable";
        }
        boolean isRollable = joint.equals("rollable");
        return prop1.m_122625_() == prop2.m_122625_().m_122424_() && (isRollable || prop1.m_122629_() == prop2.m_122629_()) && jigsaw1.f_74677_.m_128461_("target").equals(jigsaw2.f_74677_.m_128461_("name"));
    }

    public static List<InputStream> getAllFileStreams(ResourceManager resourceManager, ResourceLocation fileID) throws IOException {
        ArrayList<InputStream> fileStreams = new ArrayList<InputStream>();
        FallbackResourceManager namespaceResourceManager = ((ReloadableResourceManagerImplAccessor)resourceManager).repurposedstructures_getNamespacedManagers().get(fileID.m_135827_());
        List<PackResources> allResourcePacks = ((NamespaceResourceManagerAccessor)namespaceResourceManager).repurposedstructures_getFallbacks();
        for (PackResources resourcePack : allResourcePacks) {
            InputStream inputStream;
            if (!resourcePack.m_7211_(PackType.SERVER_DATA, fileID) || (inputStream = ((NamespaceResourceManagerAccessor)namespaceResourceManager).repurposedstructures_callGetWrappedResource(fileID, resourcePack)) == null) continue;
            fileStreams.add(inputStream);
        }
        return fileStreams;
    }

    public static Map<ResourceLocation, List<JsonElement>> getAllDatapacksJSONElement(ResourceManager resourceManager, Gson gson, String dataType, int fileSuffixLength) {
        HashMap<ResourceLocation, List<JsonElement>> map = new HashMap<ResourceLocation, List<JsonElement>>();
        int dataTypeLength = dataType.length() + 1;
        for (ResourceLocation fileIDWithExtension : resourceManager.m_6540_(dataType, fileString -> fileString.endsWith(".json"))) {
            String identifierPath = fileIDWithExtension.m_135815_();
            ResourceLocation fileID = new ResourceLocation(fileIDWithExtension.m_135827_(), identifierPath.substring(dataTypeLength, identifierPath.length() - fileSuffixLength));
            try {
                for (InputStream fileStream : GeneralUtils.getAllFileStreams(resourceManager, fileIDWithExtension)) {
                    try (BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(fileStream, StandardCharsets.UTF_8));){
                        JsonElement countsJSONElement = (JsonElement)GsonHelper.m_13776_((Gson)gson, (Reader)bufferedReader, JsonElement.class);
                        if (countsJSONElement != null) {
                            if (!map.containsKey(fileID)) {
                                map.put(fileID, new ArrayList());
                            }
                            ((List)map.get(fileID)).add(countsJSONElement);
                            continue;
                        }
                        RepurposedStructures.LOGGER.error("(Repurposed Structures {} MERGER) Couldn't load data file {} from {} as it's null or empty", (Object)dataType, (Object)fileID, (Object)fileIDWithExtension);
                    }
                }
            }
            catch (JsonParseException | IOException | IllegalArgumentException exception) {
                RepurposedStructures.LOGGER.error("(Repurposed Structures {} MERGER) Couldn't parse data file {} from {}", (Object)dataType, (Object)fileID, (Object)fileIDWithExtension, (Object)exception);
            }
        }
        return map;
    }

    public static boolean isInvalidLootTableFound(MinecraftServer minecraftServer, Map.Entry<ResourceLocation, ResourceLocation> entry) {
        boolean invalidLootTableFound = false;
        if (minecraftServer.m_129898_().m_79217_(entry.getKey()) == LootTable.f_79105_) {
            RepurposedStructures.LOGGER.error("Unable to find loot table key: {}", (Object)entry.getKey());
            invalidLootTableFound = true;
        }
        if (minecraftServer.m_129898_().m_79217_(entry.getValue()) == LootTable.f_79105_) {
            RepurposedStructures.LOGGER.error("Unable to find loot table value: {}", (Object)entry.getValue());
            invalidLootTableFound = true;
        }
        return invalidLootTableFound;
    }

    public static boolean serializeAndCompareFeature(PlacedFeature placedFeature1, PlacedFeature placedFeature2) {
        if (placedFeature1 == placedFeature2) {
            return true;
        }
        Optional<JsonElement> optionalJsonElement1 = GeneralUtils.encode(placedFeature1);
        if (optionalJsonElement1.isEmpty()) {
            return false;
        }
        Optional<JsonElement> optionalJsonElement2 = GeneralUtils.encode(placedFeature2);
        if (optionalJsonElement2.isEmpty()) {
            return false;
        }
        JsonElement featureJson1 = optionalJsonElement1.get();
        JsonElement featureJson2 = optionalJsonElement2.get();
        return featureJson1.equals(featureJson2);
    }

    public static String getCacheStats() {
        return placedFeatureCodecCache.getStats();
    }

    public static void clearCache() {
        placedFeatureCodecCache.clear();
    }

    public static Optional<JsonElement> encode(PlacedFeature feature) {
        return placedFeatureCodecCache.get(feature);
    }
}

